function [discrimspectra]=PCALDA(mzaxis,Aproj_final,Vc_final,PCs,idx,clustera,clusterb,graphtype);

%INPUTS:
%mzaxis is the mass axis that will be used to plot the discriminant
%spectrum against.

%Aproj and Vc are the outputs of the mzPCA command on the mass spectra of
%the relevant pixels.

%PCs represents the number of relevant PCs.  All other nonrelevant PCs will
%be discarded and not used by the PCALDA command.

%idx is the output from the kmeansclustering or HCAclustering commands.

%clustera and clusterb are the two groups of data you want to distinguish
%between.  Substitute the cluster numbers for these two that you want to
%distinguish between.  In the resulting discriminant spectrum, the
%positive values in the discriminant spectra are associated with clustera
%and negative values are associated with clusterb.

%graphtype - This allows the user to distinguish between two different
%types of graphical outputs for the discriminant spectrum. Type
%'singletrace' to produce a graph without shading and 'colored' to produce 
%a graph with shanding.

%OUTPUTS:
%discrimspectra - This is the calculated discriminant spectrum.

%The graphs generated by this program assume the data has been
%mean-centered as done by the mzPCA_processed command.

Vc_final(:,PCs+1:end)=[];
Aproj_final(PCs+1:end,:)=[];

cls=ClassificationDiscriminant.fit(Aproj_final',idx);
L = cls.Coeffs(clustera,clusterb).Linear;
K = cls.Coeffs(clustera,clusterb).Const;
discrimspectra=L'*Vc_final' + K;

figure;plot(Aproj_final(1,:),Aproj_final(2,:));
testa=xlim;
testb=ylim;
close
f = @(x1,x2) K + L(1)*x1 + L(2)*x2;
figure;h3 = ezplot(f,[testa testb]);
title([])

hndl=get(gca,'Children');
set(hndl,'LineWidth',2,'Color',[0 0 0]);
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
xlabel('PC 1','FontSize',16)
ylabel('PC 2','FontSize',16)
set(gca,'XTick',[])
set(gca,'YTick',[])
hold
gscatter(Aproj_final(1,:),Aproj_final(2,:),idx,'bgmcky')
%in the command above, the bgmrcky sets the color order of the points that
%scatter according to the colors associated with the plot command


if (strcmp('singletrace',graphtype)==1)
figure;plot(mzaxis,discrimspectra,'k','LineWidth',2)
hold
plot(mzaxis,zeros(size(mzaxis)),'--k','LineWidth',2)
set(gcf, 'color', 'white');
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Discriminant Spectrum','FontSize',16)
set(gca,'YTick',[])
set(gca,'FontSize',16)
elseif (strcmp('colored',graphtype)==1)
figure;plot(mzaxis,discrimspectra,'LineWidth',2)
testc=ylim;
close
testd=zeros(1,max(size(mzaxis)));
testd(:)=testc(2);
figure;h=area(mzaxis',testd','LineWidth',0.5);
set(h(1),'FaceColor',[0.8706,0.9216,0.9804]);
hold
testd(:)=testc(1);
ha=area(mzaxis',testd','LineWidth',0.5);
set(ha(1),'FaceColor',[0.9373,0.8667,0.8667]);
plot(mzaxis,discrimspectra,'k','LineWidth',2)
set(gcf, 'color', 'white');
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Discriminant Spectrum','FontSize',16)
set(gca,'YTick',[])
axis tight
set(gca,'FontSize',16)
end